---
title: Increased Browser Rendering limits! · Changelog
description: Browser Rendering now supports more concurrent browser sessions.
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-01-30-browser-rendering-more-instances/
  md: https://developers.cloudflare.com/changelog/2025-01-30-browser-rendering-more-instances/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Increased Browser Rendering limits!

Jan 30, 2025

[Workers ](https://developers.cloudflare.com/workers/)[Browser Rendering](https://developers.cloudflare.com/browser-rendering/)

[Browser Rendering](https://developers.cloudflare.com/browser-rendering/) now supports 10 concurrent browser instances per account *and* 10 new instances per minute, up from the previous limits of 2.

This allows you to launch more browser tasks from [Cloudflare Workers](https://developers.cloudflare.com/workers).

To manage concurrent browser sessions, you can use [Queues](https://developers.cloudflare.com/queues/) or [Workflows](https://developers.cloudflare.com/workflows/):

* JavaScript

  ```js
  export default {
    async queue(batch, env) {
      for (const message of batch.messages) {
        const browser = await puppeteer.launch(env.BROWSER);
        const page = await browser.newPage();


        try {
          await page.goto(message.url, {
            waitUntil: message.waitUntil,
          });
          // Process page...
        } finally {
          await browser.close();
        }
      }
    },
  };
  ```

* TypeScript

  ```ts
  interface QueueMessage {
    url: string;
    waitUntil: number;
  }


  export interface Env {
    BROWSER_QUEUE: Queue<QueueMessage>;
    BROWSER: Fetcher;
  }


  export default {
    async queue(batch: MessageBatch<QueueMessage>, env: Env): Promise<void> {
      for (const message of batch.messages) {
        const browser = await puppeteer.launch(env.BROWSER);
        const page = await browser.newPage();


        try {
          await page.goto(message.url, {
            waitUntil: message.waitUntil
          });
          // Process page...
        } finally {
          await browser.close();
        }
      }
    }
  };
  ```
