---
title: Glossary · Cloudflare Speed docs
description: Review the definitions for terms used across Cloudflare's Speed documentation.
lastUpdated: 2024-08-13T19:56:56.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/speed/glossary/
  md: https://developers.cloudflare.com/speed/glossary/index.md
---

Review the definitions for terms used across Cloudflare's Speed documentation.

| Term | Definition |
| - | - |
| bandwidth | The maximum rate of data transfer across a network. |
| brotli compression | Brotli compression is a data compression algorithm developed by Google, optimized for web content, and designed to achieve higher compression ratios than traditional algorithms like Gzip. |
| compression | The process of reducing the size of files or data to speed up their transfer over the network. |
| core web vitals | Core web vitals are a set of user-centric performance metrics, including Largest Contentful Paint (LCP), Cumulative Layout Shift (CLS), and First Input Delay (FID), used by Google to assess the overall user experience of a webpage. |
| cumulative layout shift (CLS) | Cumulative layout shift (CLS) is a web performance metric that quantifies the visual stability of a webpage by measuring the sum of unexpected layout shifts of elements during the page's loading and rendering process. |
| first contentful paint (FCP) | First contentful paint (FCP) is a web performance metric that measures the time it takes for the first piece of content to be rendered on the screen during the loading of a web page. |
| first input delay (FID) | First input delay (FID) is a web performance metric that measures the delay between a user's first interaction with a page (for example, clicking a button) and the moment the browser responds, indicating the page's interactivity and responsiveness. |
| interaction to next paint (INP) | Interaction to next paint (INP) is a web performance metric that measures the time it takes for a web page to become interactive and respond to user input after the initial paint, providing insights into the user experience during the interaction phase of page loading. |
| largest contentful paint (LCP) | Largest contentful paint (LCP) is a web performance metric that measures the time it takes for the largest content element to be fully rendered and visible to the user during the loading of a web page. |
| latency | The delay between a user action and the corresponding response from the system. |
| lazy loading | Loading images or other resources only when they are about to be displayed, rather than loading everything at once. |
| minification | The process of removing unnecessary characters from code (such as whitespace or comments) to reduce file size and improve loading times. |
| page load time | The time it takes for a web page to fully load in a user's browser. |
| real user monitoring (RUM) | Real user monitoring (RUM) is a web performance monitoring technique that collects and analyzes data based on actual user interactions and experiences, providing insights into how users interact with a website or application in real-time. |
| render time | The time it takes for a browser to display a fully rendered web page after receiving the necessary resources. |
| search engine optimization (SEO) | SEO, or search engine optimization, is the practice of optimizing online content to improve its visibility and ranking in search engine results, thereby increasing organic traffic and relevance. |
| server response time | The time it takes for a server to respond to a request from a user's browser. |
| speed index | Speed index is a web performance metric that quantifies how quickly a user perceives a webpage to load by measuring the visual progression of content rendering over time, providing a comprehensive assessment of the overall user experience during page loading. |
| synthetic test | A synthetic test is an artificial simulation of user interactions and system behaviors designed to evaluate and measure the performance, responsiveness, and functionality of a website or application under controlled conditions. |
| time to first byte (TTFB) | Time to first byte (TTFB) is the duration measured from the initiation of a web page request to the moment the first byte of data is received by the user's browser from the web server, indicating the server's initial response time. |
| time to interactive (TTI) | Time to interactive (TTI) is a web performance metric that measures the time it takes for a web page to become fully interactive and responsive to user input, indicating when users can effectively engage with and use the page. |
| total blocking time (TBT) | Total blocking time (TBT) is a web performance metric that measures the total amount of time between First Contentful Paint (FCP) and Time to Interactive (TTI) where the main thread was blocked for long enough to prevent input responsiveness. |
